local A1, A2 = 727595, 798405  -- 5^17=D20*A1+A2
local D20, D40 = 1048576, 1099511627776  -- 2^20, 2^40
local X1, X2 = 0, 1
function rand()
    local U = X2*A2
    local V = (X1*A2 + X2*A1) % D20
    V = (V*D20 + U) % D40
    X1 = math.floor(V/D20)
    X2 = V - X1*D20
    return V/D40
end
function RandBetween(a, b)
	local r = rand()
	local d = b-a
	local e = d*r
	return a + e
end

-- States:
-- 0 - initialization
-- 1 - between attacks
-- 2 - getting hit
-- 3 - ranged attack
-- 4 - special attack
-- 10 - after fight

function LookAtClaw(self)
	if self.X > GetClaw().X then
		self.DrawFlags.Mirror = false
	else
		self.DrawFlags.Mirror = true
	end
end


function main(self)
	if self.DrawFlags.Mirror then
		self.dir = 1
	else
		self.dir = -1
	end
	
	if self.State == 0 then
		self.X = 14050
		self.Y = 2464
		self.Floor = 1
		
		self.Health = 100
		self.Damage_Charge = 20
		self.Damage_Thrust = 10
		self.Damage_Touch = 5
		self.Damage_Projectile = 10
		self.Damage_Special = 5
		self.Damage = self.Damage_Touch
		self.Shot = 0
		self.Tp = 0
		self.Difficulty = 1
		
		self.AttackTypeFlags = ObjectType.Player
		self.DefaultAttackRect = {-16,-8,16,16}
		self.AttackRect = self.DefaultAttackRect
		
		self.XMin = 13536
		self.XMax = 14050
		self.Floor2Y = 2834
		self.Floor1Y = 2464
		self.Floor0Y = 2080

		self.ObjectTypeFlags = 4
		self.WpierdolCounter = 0
		
		self.NormalReload = 1200
		self.SpecialReload = 2500
		
		self.I = 1
		self:SetImage("LEVEL_ARETI")
		--self:SetAnimation("GAME_NULL")
		self.Z = 4001
		
		self.TimeCounter = GetTime() + self.NormalReload
		
		self.HitTypeFlags = 50335794
		--self.HitTypeFlags = ObjectType.Player + ObjectType.PShot
		self.HitRect = {-14,-35,14,31}
		
		
		self.State = 1
	elseif self.State == 1 then -- 1 - between attacks
		local claw = GetClaw()
		
		if self.WpierdolCounter >= 2 then
			self.WpierdolCounter = 0
			if self.Tp == 0 then
				self.Tp = 1
				self.TempStunCounter = GetTime() + 1000
				self.State = 5 -- charge
				self.startX = self.X
				if self.startX == self.XMin then
					self.finalX = self.XMax
					self.chargeDir = 1
				else
					self.finalX = self.XMin
					self.chargeDir = -1
				end
			else
				self.Tp = 0
				self.TempStunCounter = GetTime() + 1000
				self.Difficulty = self.Difficulty + 1
				self.State = 6 -- tp
			end
			
		end
		if self.Health <= 20 then
			self.State = 10
		end
		
		if claw.State == 5009 or claw.Health <= 0 then -- wait for battle to start
			self.TimeCounter = GetTime() + self.NormalReload
			LookAtClaw(self)
		end
		if self.TimeCounter < GetTime() then
			if math.abs(self.Y - claw.Y + 32) < 160 and GetClaw().State ~= 26 then
				LookAtClaw(self)
				self.TempStunCounter = GetTime() + 1000 -- póki nie ma animacji, 1 sekunda na przygotowanie ataku
				--PlaySound("CUSTOM_TRIGGER_3KNIVES")
				self.State = 3
			elseif self.TimeCounter < GetTime() - 1500 then -- Areti prefers regular Attack, will use it if possible, also increases interval between special attacks a bit
				LookAtClaw(self)
				self.TempStunCounter = GetTime() + 1000 -- póki nie ma animacji, 1 sekunda na przygotowanie ataku
				--PlaySound("CUSTOM_TRIGGER_3KNIVES")
				self.State = 4
			end
		end
	elseif self.State == 2 then -- 2 - getting hit
		if self.TempStunCounter <= GetTime() then
			self.State = 1
			self.I = 1
			--self:SetAnimation("LEVEL_REDTAIL_IDLE")
			self.TimeCounter = GetTime() + 1000
		end
	elseif self.State == 3 then -- 3 - ranged attack
		if self.TempStunCounter <= GetTime() and self.Shot == 0 then
			PlaySound("CUSTOM_TRIGGER_TLIGHTNING")
			--TextOut("dd")
			local tmptrd = CreateObject {x=self.X + self.dir*64, y=self.Y-12, z=4100, logic="TridentBullet", image="CUSTOM_ARETITRIDENT", SpeedX = 580*self.dir, Damage = 10}
			tmptrd.DrawFlags.Mirror = self.DrawFlags.Mirror
			self.Shot = 1
		end
		if self.TempStunCounter <= GetTime() and self.Shot == 1 then
			
			self.Shot = 0
			self.State = 1
			--self:SetAnimation("LEVEL_REDTAIL_IDLE")
			self.TimeCounter = GetTime() + self.NormalReload
		end
	elseif self.State == 4 then -- 4 - special attack
		if self.TempStunCounter <= GetTime()+500 and self.Shot == 0 then
			
			--TextOut("dd")
			local claw = GetClaw()
			local dgr2 = math.deg(math.atan2((claw.Y-self.Y),(claw.X-self.X)))+180
			local f = 224
			if self.Difficulty == 1 then
				CreateObject {x=claw.X + math.cos(math.rad(dgr2))*f, y=claw.Y + math.sin(math.rad(dgr2))*f, z=4200, name="SpecialProjectile", logic="CustomLogic", image="CUSTOM_SPECIALPROJECTILE", Smarts = 1000}
			elseif self.Difficulty == 2 then
				CreateObject {x=claw.X + math.cos(math.rad(dgr2-15))*f, y=claw.Y + math.sin(math.rad(dgr2-15))*f, z=4200, name="SpecialProjectile", logic="CustomLogic", image="CUSTOM_SPECIALPROJECTILE", Smarts = 1000}
				CreateObject {x=claw.X + math.cos(math.rad(dgr2+15))*f, y=claw.Y + math.sin(math.rad(dgr2+15))*f, z=4200, name="SpecialProjectile", logic="CustomLogic", image="CUSTOM_SPECIALPROJECTILE", Smarts = 2000}
			elseif self.Difficulty == 3 then
				CreateObject {x=claw.X + math.cos(math.rad(dgr2-30))*f, y=claw.Y + math.sin(math.rad(dgr2-30))*f, z=4200, name="SpecialProjectile", logic="CustomLogic", image="CUSTOM_SPECIALPROJECTILE", Smarts = 1000}
				CreateObject {x=claw.X + math.cos(math.rad(dgr2))*f, y=claw.Y + math.sin(math.rad(dgr2))*f, z=4200, name="SpecialProjectile", logic="CustomLogic", image="CUSTOM_SPECIALPROJECTILE", Smarts = 1500}
				CreateObject {x=claw.X + math.cos(math.rad(dgr2+30))*f, y=claw.Y + math.sin(math.rad(dgr2+30))*f, z=4200, name="SpecialProjectile", logic="CustomLogic", image="CUSTOM_SPECIALPROJECTILE", Smarts = 2000}
			elseif self.Difficulty >= 4 then
				CreateObject {x=claw.X + math.cos(math.rad(dgr2-40))*f, y=claw.Y + math.sin(math.rad(dgr2-40))*f, z=4200, name="SpecialProjectile", logic="CustomLogic", image="CUSTOM_SPECIALPROJECTILE", Smarts = 2750}
				CreateObject {x=claw.X + math.cos(math.rad(dgr2-20))*f, y=claw.Y + math.sin(math.rad(dgr2-20))*f, z=4200, name="SpecialProjectile", logic="CustomLogic", image="CUSTOM_SPECIALPROJECTILE", Smarts = 1750}
				CreateObject {x=claw.X + math.cos(math.rad(dgr2))*f, y=claw.Y + math.sin(math.rad(dgr2))*f, z=4200, name="SpecialProjectile", logic="CustomLogic", image="CUSTOM_SPECIALPROJECTILE", Smarts = 1000}
				CreateObject {x=claw.X + math.cos(math.rad(dgr2+20))*f, y=claw.Y + math.sin(math.rad(dgr2+20))*f, z=4200, name="SpecialProjectile", logic="CustomLogic", image="CUSTOM_SPECIALPROJECTILE", Smarts = 1750}
				CreateObject {x=claw.X + math.cos(math.rad(dgr2+40))*f, y=claw.Y + math.sin(math.rad(dgr2+40))*f, z=4200, name="SpecialProjectile", logic="CustomLogic", image="CUSTOM_SPECIALPROJECTILE", Smarts = 2750}
			end
			
			
			self.Shot = 1
		end
		if self.TempStunCounter <= GetTime()+500 and self.Shot == 1 then
			
			self.Shot = 0
			self.State = 1
			--self:SetAnimation("LEVEL_REDTAIL_IDLE")
			self.TimeCounter = GetTime() + self.SpecialReload
		end
	elseif self.State == 5 then -- 5 - charge
		if self.TempStunCounter <= GetTime() then
			self.Damage = self.Damage_Charge
			self.X = self.X + self.chargeDir*10
		end
		if ( self.chargeDir == 1 and self.X >= self.finalX ) or ( self.chargeDir == -1 and self.X <= self.finalX ) then
			self.State = 1
			self.Damage = self.Damage_Touch
			self.TimeCounter = GetTime() + self.NormalReload
			LookAtClaw(self)
		end
	elseif self.State == 6 then -- 6 - tp
		local r = rand()
		if self.Difficulty == 2 then
			self.Y = self.Floor0Y
			self.X = self.XMin
		elseif self.Difficulty == 3 then
			self.Y = self.Floor2Y
			self.X = self.XMin
		elseif self.Difficulty == 4 then
			self.Y = self.Floor0Y
			self.X = self.XMin
		else
		
		if self.Y == self.Floor0Y then
			if r < 0.5 then
				self.Y = self.Floor1Y
				self.X = self.XMax
			else
				self.Y = self.Floor2Y
				self.X = self.XMin
			end
		elseif self.Y == self.Floor1Y then
			if r < 0.5 then
				self.Y = self.Floor0Y
				self.X = self.XMin
			else
				self.Y = self.Floor2Y
				self.X = self.XMin
			end
		else
			if r < 0.5 then
				self.Y = self.Floor0Y
				self.X = self.XMin
			else
				self.Y = self.Floor1Y
				self.X = self.XMax
			end
		end
		end
		self.State = 1
		self.TimeCounter = GetTime() + self.NormalReload
		LookAtClaw(self)
	end
	
	
	--TextOut(self.I)
	--self:SetFrame(self.I)
	--self:AnimationStep()
end

function hit(self)
	
	--local claw = GetClaw()
	--if self.State == 1 then
		
		--TextOut(self.HitRef.ObjectTypeFlags)
		if self.HitRef.ObjectTypeFlags == 2 and self.State == 1 and self.WpierdolCounter < 2 then
			self.State = 2
			self.I = 2
			
			local r = rand()
			if r<0.25 then
				PlaySound("GAME_HIT1")
			elseif r<0.5 then
				PlaySound("GAME_HIT2")
			elseif r<0.75 then
				PlaySound("GAME_HIT3")
			else
				PlaySound("GAME_HIT4")
			end
			if GetClaw().State == 26 then
				self.Health = self.Health - 5
			else
				self.Health = self.Health - 5
			end
			self.TempStunCounter = GetTime() + 500 -- póki nie ma animacji, 1/2 sekundy nieśmiertelności po otrzymaniu obrażeń
			self.WpierdolCounter = self.WpierdolCounter + 1
			TextOut(self.WpierdolCounter)
		elseif self.HitRef.ObjectTypeFlags == 32 or self.HitRef.Logic==Dynamite then
			self.HitRef.Y = 9900
			--PlaySound("LEVEL_REDTAIL_BLOCK2")
			--self.QuickReloadCounter = 2
			if self.TimeCounter-GetTime() < self.NormalReload then
				self.TimeCounter = self.TimeCounter + 500
			else
				self.TimeCounter = GetTime() + self.NormalReload + 500
			end
		elseif self.HitRef.Logic==MagicBullet then
			self.HitRef.Y = 9900
			--PlaySound("LEVEL_REDTAIL_BLOCK2")
			--self.QuickReloadCounter = 2
			self.TimeCounter = GetTime() + self.NormalReload + 500
		end
		--TextOut(GetClaw().State)
		
		
	--end
end 